<?php

namespace App;

class SessionManager
{
    private $sessionPath;

    public function __construct($sessionPath = null)
    {
        $this->sessionPath = $sessionPath ?? sys_get_temp_dir() . '/botajs_sessions';
        if (!is_dir($this->sessionPath)) {
            mkdir($this->sessionPath, 0755, true);
        }
        session_save_path($this->sessionPath);
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }

    public function set($key, $value)
    {
        $_SESSION[$key] = $value;
    }

    public function get($key, $default = null)
    {
        return $_SESSION[$key] ?? $default;
    }

    public function delete($key)
    {
        unset($_SESSION[$key]);
    }

    public function has($key)
    {
        return isset($_SESSION[$key]);
    }
}