<?php

namespace App;

class Config
{
    private static $config = [];

    public static function load($envFile)
    {
        if (!file_exists($envFile)) {
            throw new \Exception("Environment file not found: {$envFile}");
        }

        $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

        foreach ($lines as $line) {
            if (strpos($line, '=') === false || strpos($line, '#') === 0) {
                continue;
            }

            [$key, $value] = explode('=', $line, 2);
            $key = trim($key);
            $value = trim($value);

            putenv("{$key}={$value}");
            self::$config[$key] = $value;
        }
    }

    public static function get($key, $default = null)
    {
        return self::$config[$key] ?? getenv($key) ?? $default;
    }
}