<?php

require __DIR__ . '/../vendor/autoload.php';

use App\Request;

$request = new Request();
$method = $request->getMethod();
$path = $request->getPath();

// Strip /public prefix if present
$path = preg_replace('#^/public#', '', $path);

$routes = [
    'POST' => [
        '/api/git/generate-key' => __DIR__ . '/../api/generate-key.php',
        '/api/git/get-key' => __DIR__ . '/../api/get-key.php',
        '/api/bots/export' => __DIR__ . '/../api/export-bot.php',
        '/api/bots/import' => __DIR__ . '/../api/import-bot.php',
        '/api/user/ssh-keys' => __DIR__ . '/../api/user-ssh-keys.php',
    ]
];

if (isset($routes[$method][$path])) {
    require $routes[$method][$path];
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Endpoint not found']);
}
