#!/bin/bash

# BotAJS Git Integration - Example Usage Script
# This script demonstrates how to use the API endpoints

# Configuration
API_URL="http://localhost:8000"
API_KEY="your-secret-api-key-here"
USER_ID="my_user_123"
BOT_ID="your_bot_id"
BOTAJS_API_KEY="your_botajs_api_key"
GIT_REPO="git@github.com:username/repo.git"
GIT_BRANCH="main"
USER_EMAIL="you@example.com"

echo "=== BotAJS Git Integration - Example Usage ==="
echo ""

# Function to make API calls
call_api() {
    local endpoint=$1
    local data=$2

    echo "Calling: ${API_URL}${endpoint}"
    curl -X POST "${API_URL}${endpoint}" \
        -H "X-API-KEY: ${API_KEY}" \
        -H "Content-Type: application/json" \
        -d "${data}" \
        -w "\nHTTP Status: %{http_code}\n" \
        -s
    echo ""
    echo "---"
    echo ""
}

# Example 1: Generate SSH Deploy Key
echo "Example 1: Generate SSH Deploy Key"
echo "===================================="
call_api "/api/git/generate-key" \
    "{\"user_id\": \"${USER_ID}\"}"

echo "Action Required:"
echo "1. Copy the public_key from the response above"
echo "2. Go to GitHub → Your Repo → Settings → Deploy keys"
echo "3. Click 'Add deploy key'"
echo "4. Paste the public key"
echo "5. Check 'Allow write access'"
echo "6. Save"
echo ""
read -p "Press Enter after adding the deploy key to GitHub..."
echo ""

# Example 2: Get Public Key (retrieve previously generated key)
echo "Example 2: Retrieve Public Key"
echo "==============================="
call_api "/api/git/get-key" \
    "{\"user_id\": \"${USER_ID}\"}"

# Example 3: Export Bot to GitHub
echo "Example 3: Export Bot to GitHub"
echo "================================"
call_api "/api/bots/export" \
    "{
        \"user_id\": \"${USER_ID}\",
        \"botId\": \"${BOT_ID}\",
        \"git_repo_url\": \"${GIT_REPO}\",
        \"git_branch\": \"${GIT_BRANCH}\",
        \"commit_message\": \"Automated bot export\",
        \"user_email\": \"${USER_EMAIL}\",
        \"api_key\": \"${BOTAJS_API_KEY}\"
    }"

echo "Check your GitHub repository to see the exported bot files!"
echo ""

# Example 4: Import Bot from GitHub
echo "Example 4: Import Bot from GitHub"
echo "=================================="
call_api "/api/bots/import" \
    "{
        \"user_id\": \"${USER_ID}\",
        \"botId\": \"${BOT_ID}\",
        \"git_repo_url\": \"${GIT_REPO}\",
        \"git_branch\": \"${GIT_BRANCH}\",
        \"api_key\": \"${BOTAJS_API_KEY}\"
    }"

echo "Bot commands have been imported from GitHub!"
echo ""

# Advanced Example: Export with custom commit message
echo "Advanced Example: Custom Commit Message"
echo "========================================"
CUSTOM_MESSAGE="feat: update bot commands - $(date '+%Y-%m-%d %H:%M')"
call_api "/api/bots/export" \
    "{
        \"user_id\": \"${USER_ID}\",
        \"botId\": \"${BOT_ID}\",
        \"git_repo_url\": \"${GIT_REPO}\",
        \"git_branch\": \"${GIT_BRANCH}\",
        \"commit_message\": \"${CUSTOM_MESSAGE}\",
        \"user_email\": \"${USER_EMAIL}\",
        \"api_key\": \"${BOTAJS_API_KEY}\"
    }"

echo ""
echo "=== Complete! ==="
echo ""
echo "Tips:"
echo "- Store your API keys securely (never commit to git)"
echo "- Use different user_id for different users/sessions"
echo "- SSH keys are stored per user_id in sessions"
echo "- You can export to different branches for staging/production"
echo ""
